/*
 * Decompiled with CFR 0.152.
 */
package classes.prohibition;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.InputStream;
import java.net.URL;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.DataLine;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;

public class Samples {
    Clip[] clip;
    byte[] buffer;
    String[] names = new String[]{"classes/resources/sfx/tick.wav", "classes/resources/sfx/tick0.wav", "classes/resources/sfx/tick2.wav", "classes/resources/sfx/shoot1.wav", "classes/resources/sfx/shoot_air1.wav", "classes/resources/sfx/hide.wav", "classes/resources/sfx/enemyhit.wav", "classes/resources/sfx/backtolife.wav", "classes/resources/sfx/prohibition.wav", "classes/resources/sfx/scores.wav", "classes/resources/sfx/tapenoise.wav"};
    public int TICK = 0;
    public int TICK0 = 1;
    public int TICK1 = 2;
    public int SHOT = 3;
    public int SHOT1 = 4;
    public int HIDE = 5;
    public int HIT = 6;
    public int BACK = 7;
    public int MUSIC = 8;
    public int SCORES = 9;
    public int TAPENOISE = 10;
    public boolean nosamples = false;
    public static boolean quiet;
    static boolean run;
    static boolean c;
    static int l;
    static int r;
    static int told;
    static int tnew;
    static Color trans;
    static Color trans2;
    static Color trans3;

    public void init() {
        this.nosamples = false;
        this.clip = new Clip[this.names.length];
        try {
            for (int i = 0; i < this.clip.length; ++i) {
                URL url = this.getClass().getClassLoader().getResource(this.names[i]);
                AudioInputStream audioIn = AudioSystem.getAudioInputStream(url);
                AudioFormat format = audioIn.getFormat();
                DataLine.Info info = new DataLine.Info(Clip.class, format);
                this.clip[i] = (Clip)AudioSystem.getLine(info);
                this.clip[i].open(audioIn);
                if (!run || i != this.MUSIC) continue;
                this.buffer = this.getRom("resources/sfx/prohibition.wav", this.clip[i].getFrameLength() * 2 + 44);
                byte[] b = new byte[this.buffer.length - 44];
                System.arraycopy(this.buffer, 44, b, 0, b.length);
                this.buffer = new byte[b.length];
                System.arraycopy(b, 0, this.buffer, 0, b.length);
            }
        }
        catch (Exception e) {
            this.initb();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getRom(String name, int size) {
        byte[] buffer = new byte[size];
        int offs = 0;
        try (InputStream stream = null;){
            InputStream is;
            stream = is = this.getClass().getResourceAsStream(name);
            while (size > 0) {
                int read = stream.read(buffer, offs, size);
                if (read == -1) {
                    break;
                }
                offs += read;
                size -= read;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return buffer;
    }

    public void initb() {
        this.clip = new Clip[this.names.length];
        String inf = "Can't detect audioformat!";
        try {
            for (int i = 0; i < this.clip.length; ++i) {
                URL url = this.getClass().getClassLoader().getResource(this.names[i]);
                AudioInputStream audioIn = AudioSystem.getAudioInputStream(url);
                inf = audioIn.getFormat().toString();
                this.clip[i] = AudioSystem.getClip();
                this.clip[i].open(audioIn);
            }
        }
        catch (Exception e) {
            System.err.println("Your system does not support audio or my audioformat!!!");
            System.err.println(inf);
            this.nosamples = true;
        }
    }

    public void play(int index) {
        if (quiet) {
            return;
        }
        if (this.nosamples) {
            return;
        }
        if (this.clip[index].isRunning()) {
            this.clip[index].stop();
        }
        this.clip[index].setFramePosition(0);
        this.clip[index].start();
    }

    public void loop(int index) {
        if (this.nosamples) {
            return;
        }
        if (this.clip[index].isRunning()) {
            this.clip[index].stop();
        }
        this.clip[index].setFramePosition(0);
        Clip cfr_ignored_0 = this.clip[index];
        this.clip[index].loop(-1);
    }

    public Clip getClip(int index) {
        return this.clip[index];
    }

    public void stop(int index) {
        if (this.nosamples) {
            return;
        }
        if (this.clip[index].isRunning()) {
            this.clip[index].stop();
        }
        this.clip[index].setFramePosition(0);
        this.clip[index].stop();
    }

    public static void main(String[] args) {
        int h;
        run = true;
        int width = 800;
        JFrame fram = new JFrame("Test");
        fram.setLayout(new BorderLayout());
        final JLabel pan = new JLabel();
        pan.setPreferredSize(new Dimension(800, 300));
        fram.add((Component)pan, "Center");
        fram.pack();
        fram.setVisible(true);
        fram.setResizable(false);
        fram.setDefaultCloseOperation(3);
        final Samples sam = new Samples();
        sam.init();
        final BufferedImage im = new BufferedImage(800, 300, 1);
        final BufferedImage im1 = new BufferedImage(800, 300, 1);
        im1.setAccelerationPriority(1.0f);
        final Graphics2D g = im.createGraphics();
        final Clip p = sam.getClip(sam.MUSIC);
        pan.setVisible(true);
        int t = p.getFrameLength();
        final int pp = t / 800;
        int pb = sam.buffer.length / 800;
        Graphics2D p2 = im1.createGraphics();
        p2.setColor(Color.white);
        p2.fillRect(0, 151, 800, 2);
        p2.setColor(trans2);
        int d = sam.buffer[0] & 0xFF;
        int pt = 0;
        double div = 0.8;
        int pr = 0;
        for (h = 0; h < sam.buffer.length; h += 2) {
            if (++pr != 20) continue;
            pr = 0;
            pt = h / pb;
            p2.drawLine(pt, (int)((double)d * div) + 49, pt, (int)((double)(255 - (sam.buffer[h] & 0xFF)) * div) + 49);
            d = 255 - (sam.buffer[h] & 0xFF);
        }
        p2.setColor(trans3);
        pr = 0;
        for (h = 1; h < sam.buffer.length; h += 2) {
            if (++pr != 20) continue;
            pr = 0;
            pt = h / pb;
            p2.drawLine(pt, (int)((double)d * div) + 51, pt, (int)((double)(sam.buffer[h] & 0xFF) * div) + 51);
            d = sam.buffer[h] & 0xFF;
        }
        Thread rp = new Thread(){

            @Override
            public void run() {
                int tt = p.getFramePosition() / pp;
                if (tt == p.getFrameLength() / pp) {
                    p.setFramePosition(0);
                    tt = 0;
                }
                if (tt != told) {
                    g.drawImage(im1, 0, 0, null);
                    g.setColor(trans);
                    g.fillRect(tt - 2, 0, 2, 400);
                }
                int v = p.getFramePosition();
                c = false;
                if ((v & 1) == 1) {
                    c = true;
                }
                if (c) {
                    r = v;
                } else {
                    l = v;
                }
                g.setColor(Color.yellow);
                g.fillRect(0, 20, (sam.buffer[r] & 0xFF) * 3, 8);
                g.setColor(Color.red);
                g.fillRect(0, 4, (sam.buffer[l] & 0xFF) * 3, 8);
                pan.setIcon(new ImageIcon(im));
                told = tt;
                p.loop(10);
            }
        };
        while (true) {
            rp.run();
        }
    }

    static {
        run = false;
        trans = new Color(255, 0, 0, 144);
        trans2 = new Color(64, 255, 64, 32);
        trans3 = new Color(255, 64, 64, 32);
    }
}

